
clear all
close all
clc

%%

load("POS_SIN1")

dt1=1/4000;

%%

time          =  POS_SIN1.dieci.HzUno.data.time;
P_1           =  POS_SIN1.dieci.HzUno.data.P_1;
P_2           =  POS_SIN1.dieci.HzUno.data.P_2;
Spool_FB      =  POS_SIN1.dieci.HzUno.data.Spool_FB;
Spool_Cmd     =  POS_SIN1.dieci.HzUno.data.Spool_Cmd;
Pos_FB_SP     =  POS_SIN1.dieci.HzUno.data.Pos_Feedback;
Pos_SET       =  POS_SIN1.dieci.HzUno.data.PosSet;
Ki_Pos_out    =  POS_SIN1.dieci.HzUno.data.Ki_Pos_out;
Delta_P       =  P_2-P_1;

time=1:1:length(Pos_SET);
time=[0 ; time(1:end-1)'*dt1];

%% Parametri simulink 

dt=1/4000;
StopTime=time(end);

p_S=280e5;                 %% pressione di alimentazione [Pa]
p_T=1e5;                   %% pressione di scarico [Pa]
P_A0=P_2(1)*10^5;          %% pressione iniziale nelle camere [Pa]  
P_B0=P_1(1)*10^5;          %% pressione iniziale nelle camere [Pa]  
rho=900;                   %% densità olio [kg/m^3]
beta=1560548312.31322;     %% modulo di bulk [Pa]
mu=0.0273;                 %% viscosità dinamica [Pa*s]
gamma=700;                 %% coefficiente di smorzamento viscoso dell'olio [N/(m/s)]

%% Parametri Controllo

Ki_offset=Ki_Pos_out(1);

dt=1/4000;
Pos_Gain=1;
SV_Sat=2;


Pos_FI=3;
Pos_pband=300;
Dead_Low_Pos=-0.05;
Dead_Up_Pos=0.05;
SV_LC_sign_Pos=-1;

Kp_Pos=0.76;
Ki_Pos=2.05;
G1_Pos=0.15;
Gp_Pos=0;
Gx_Pos=0;
Gd_Pos=6.5e-07;
Kx_min_Pos=1;

PD_Pos_tau1=0.0025;
PD_Pos_tau2=0.0025;
PD_Pos_tau3=0.0025;
PD_Pos_tau4=0.0025;

Gp_Pos_tau1=0.0025;
Gp_Pos_tau2=0.0025;

G1_Pos_tau1=0.0025;
G1_Pos_tau2=0.0025;

Gd_Pos_tau1=0.0025;
Gd_Pos_tau2=0.0025;

G1_bias=0.6;


i_sat_up_Pos=6;
i_sat_down_Pos=-6;
G1_Sat=2;
Sat_Pos=5;

P_FI=3;
Load_pband=10;

%% Servovalvola

sigma_n=150*2*pi;
K_s=0.0000731;
zeta_n=0.7;


w=0.0249;                             %% luce [m]

eps_1=-3.7e-6;                        %% ricoprimento S-A [m]
eps_2=-3.7e-6;                        %% ricoprimento B-T [m]
eps_3=-3.7e-6;                        %% ricoprimento S-B [m]
eps_4=-3.7e-6;                        %% ricoprimento A-T [m]

C_d1=0.53;
C_d2=0.63;
C_d3=0.52;
C_d4=0.61;

bias=0;  % bias [m] calcolato da una prova con comando nullo
% 0.2957

%% Attuatore 

d_stantuffo=0.074;                                        %% diametro stantuffo[m]
d_stelo=0.05;                                             %% diametro stelo [m]
semicorsa1=0.075;                                         %% semicorsa lato camera a pressione P_A [m]
semicorsa2=0.075;                                         %% semicorsa lato camera a pressione P_B [m]
extracorsa=0.018;
A_1=pi*(d_stantuffo^2-d_stelo^2)/4;                       %% superficie stantuffo camera di spinta [m^2]
A_2=pi*(d_stantuffo^2-d_stelo^2)/4;                       %% superficie stantuffo [m^2]
V_1=A_1*semicorsa1;                                       %% volume iniziale camera uno [m^3]
V_2=A_2*semicorsa2;                                       %% volume iniziale camera due [m^3]
V_ds1=extracorsa*A_1;                                     %% volume di spazio morto camera uno [m^3]
V_ds2=V_ds1;                                              %% volume di spazio morto camera due [m^3]


Cd_gioco=0.8;                                           %% coefficiente di efflusso [-]
gioco_radiale=1.67e-06;                                   %% gioco radiale [m]
l_stantuffo=0.094;                                        %% lunghezza stantuffo [m]
m_stelo=10;                                               %% [kg]
m_stantuffo=10;                                           %% [kg]
m_slitta=6;                                               %% [kg]
m_cella=2;                                                %% [kg]
m=m_stelo+m_stantuffo+m_slitta+m_cella;                   %% [kg]



F_stall=(p_S-p_T)*A_1;                         

%% Attrito Coulomb

mu_c=0.79;
g=9.81;

F_static=100;

%% foro di by-pass

d_BP=1.8e-3;             %% diametro orifizio [m]
A_BP=pi*d_BP^2/4;        %% sezione di passaggio [m^2]
Cd_BP=0.8;

%% Trasduttore

K_x=1;        %% guadagno statico [-]

%% Lancio il modello

sim('Pos_Cntrl.slx');

%%
close all


figure
title('Posizione Sperimentale e Simulata in [mm]')
plot(time,Pos_SET,LineWidth=2)
hold on 
plot(tout,x_FB,LineWidth=2)
hold on
plot(time,Pos_FB_SP,LineWidth=2)
legend('Set','Simulato','Sper')
ylabel('Position [mm]')
xlabel('t [s]')
set(gca,'FontSize',14)
